unit Unit3;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, Menus,
{$IFDEF WINDOWS}
  Registry,
{$ELSE}
  BaseUnix, TermIO,
{$ENDIF}
  LCLType, LCLIntf, ExtCtrls;

type

  { TForm3 }

  TForm3 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    CheckBox1: TCheckBox;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    PopupMenu1: TPopupMenu;
    procedure ComboBox1DropDown(Sender: TObject);
    procedure ComboBoxANYKeyDown(Sender: TObject; var Key: Word; {%H-}Shift: TShiftState);
    procedure Label3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private

  public

  end;

var
//Form3: TForm3;                            // not needed here - form is created by caller
  PortName:string;
  PortRate:integer;

implementation

{$R *.lfm}

{ TForm3 }

const NPFstring='  - no ports found -  ';

{$IFDEF WINDOWS}

procedure PopulatePortList(var PortList:TStringList);
var Reg:TRegistry;
      I:integer;
begin
  Reg:=TRegistry.Create;
  PortList.Clear;
  with Reg do
  try
    RootKey:=HKEY_LOCAL_MACHINE;
    if OpenKeyReadOnly('hardware\devicemap\serialcomm') then
    begin
      GetValueNames(PortList);
      for I:=0 to PortList.Count-1 do
        PortList.Strings[I]:=ReadString(PortList.Strings[I]);
      if PortList.Count=0 then PortList.Add(NPFstring)
    end;
  finally
    CloseKey
  end;
  Reg.Free;
  PortList.Sort
end;

{$ELSE}

type
   TSerialStruct = packed record
          typ: cint;
          line: cint;
          port: cuint;
          irq:  cint;
          flags: cint;
          xmit_fifo_size: cint;
          custom_divisor: cint;
          baud_base: cint;
          close_delay: cushort;
          io_type: cchar;
          reserved_char:  pcchar;
          hub6: cint;
          closing_wait: cushort; // time to wait before closing
          closing_wait2: cushort; // no longer used...
          iomem_base: pcchar;
          iomem_reg_shift: cushort;
          port_high: clong; // cookie passed into ioremap
   end;


// method based on information obtained from the following two sites:
// https://www.lazarusforum.de/viewtopic.php?p=72837
// https://stackoverflow.com/questions/2530096
function CheckDevice(DeviceName:string):boolean;               // checks to see if the device named is a live
var DriverName:string;                                         // ... serial port. this is done by checking
            FD:longint;                                        // ... entries in /sys/class/tty, including the
            SS:TSerialStruct;                                  // ... presence of a link to a device driver.
            ST:stat;
begin
  Result:=false;
  ST.st_mode:=0;

  if (DeviceName<>'.') and (DeviceName<>'..') then
  if FileExists('/sys/class/tty/'+DeviceName+'/device/driver') or
     DirectoryExists('/sys/class/tty/'+DeviceName+'/device/driver') then
  if fpLstat('/sys/class/tty/'+DeviceName+'/device', ST)=0 then
  if fpS_ISLNK(ST.st_mode) then
  begin
    DriverName:=ExtractFileName(fpReadLink('/sys/class/tty/'+DeviceName+'/device/driver'));
//  writeln(DeviceName,'  :  ',DriverName);

    if DriverName<>'serial8250' then Result:=true
                                else begin
//                                     writeln('    checking serial8250 device');
                                       FD:=fpOpen('/dev/'+DeviceName, O_RDWR or O_NONBLOCK or O_NOCTTY);
                                       if FD>0 then
                                       try
                                         if fpIOCtl(FD, TIOCGSERIAL, @SS)<>-1 then
                                         if SS.typ<>0 then Result:=true;
                                         fpclose(FD)
                                       except end
                                     end
  end
end;


procedure PopulatePortList(var PortList:TStringList);
var S1,S2:string;
    I,J,K:integer;
     done:boolean;
       SR:TSearchRec;
begin
  PortList.Clear;

  if FindFirst('/sys/class/tty/*', faDirectory , SR) = 0 then                  // initially we scan /sys/class/tty for potential serial ports
  repeat                                                                       //                   ~~~~~~~~~~~~~~
//  writeln(SR.Name);
    if CheckDevice(SR.Name) then PortList.Add('/dev/'+SR.Name)                 // check that each port found is live, add to PortList if it is
  until FindNext(SR) <> 0;
  FindClose(SR);

  if PortList.Count=0 then PortList.Add(NPFstring) else                        // ALWAYS have at least ONE item in list, even if a 'not found' message
  repeat                                                                       // excessively complicated sort routine, tries to ensure that the
    done:=true;                                                                // 'fixed' serial ports appear last, and that port numbers are
    for I:=0 to PortList.Count-2 do                                            // ordered correctly: 0,1,2...,8,9,10,11, etc.
    begin
      S1:=PortList[I];
      J:=1+length(S1);

      S2:=PortList[I+1];
      K:=1+length(S2);

      if (J-K)<0 then begin                                                    // pack S1 with zeros to left of numeric part
                        while (J>1) and (S1[J-1] in ['0'..'9']) do dec(J);
                        while length(S1)<length(S2) do insert('0', S1, J)
                      end else
      if (K-J)<0 then begin                                                    // pack S2 with zeros to left of numeric part
                        while (K>1) and (S2[K-1] in ['0'..'9']) do dec(K);
                        while length(S2)<length(S1) do insert('0', S2, K)
                      end;

      J:=pos('ttyS',S1);                                                       // <>0 if is a 'fixed' serial port
      K:=pos('ttyS',S2);                                                       // <>0 if is a 'fixed' serial port

//    if ((J=0) and (K<>0)) or                                                 // bubble ttyS* ports to top of the list
//       ((J=K) and (S1>S2)) then                                              // within respective groups sort alphabetically
      if ((J<>0) and (K=0)) or                                                 // push ttyS* ports to bottom of the list
         ((J=K) and (S1>S2)) then                                              // within respective groups sort alphabetically
      begin
        PortList.Exchange(I, I+1);
        done:=false                                                            // flag set if at least one swap during this pass
      end
    end
  until done
end;

{$ENDIF}

procedure TForm3.Button1Click(Sender: TObject);
var f:TCustomForm;
begin
  f:=GetParentForm(Self);
  if f<>nil then f.ModalResult:=mrCancel
end;


procedure TForm3.Button2Click(Sender: TObject);
var f:TCustomForm;
    I:int64;
begin
  f:=GetParentForm(Self);
  if f<>nil then
  begin
    if ComboBox1.Text=NPFstring then f.ModalResult:=mrCancel else
    begin
      PortName:=Trim(ComboBox1.Text);
      try PortRate:=StrToInt(Trim(ComboBox2.Text)) except PortRate:=38400 end;

      if GetKeyState(VK_CONTROL)<0 then                                        // control key is pressed, do special connect for pico
      begin
        Button1.Enabled:=false;
        Button2.Enabled:=false;
        I:=GetTickCount64+9999;                                                // 10 seconds to unplug and replug
        Label3.Font.Color:=clMaroon;
        while FileExists(PortName)     and ((I-GetTickCount64)>0) do begin
                                                                       Label3.Caption:=RightStr(IntToStr(50000+I-GetTickCount64),4)+'ms';
                                                                       Application.ProcessMessages
                                                                     end;
        Label3.Font.Color:=clGreen;
        while not FileExists(PortName) and ((I-GetTickCount64)>0) do begin
                                                                       Label3.Caption:=RightStr(IntToStr(50000+I-GetTickCount64),4)+'ms';
                                                                       Application.ProcessMessages
                                                                     end;
        sleep(100)
      end;

      f.ModalResult:=mrOk
    end
  end
end;


procedure TForm3.ComboBox1DropDown(Sender: TObject);
var SL:TStringList;
    S0:string;
     I:integer;
begin
  S0:=ComboBox1.Text;
  SL:=TStringList.Create;
  PopulatePortList(SL);
  ComboBox1.Items:=SL;
  ComboBox1.ItemIndex:=0;
  SL.Free;
  with ComboBox1 do for I:=0 to Items.Count-1 do if Items[I]=S0 then ItemIndex:=I
end;


procedure TForm3.FormCreate(Sender: TObject);
var SL:TStringList;
     I:integer;
begin
  SL:=TStringList.Create;
  PopulatePortList(SL);
  ComboBox1.Items:=SL;
  ComboBox1.ItemIndex:=0;
  SL.Free;
  with ComboBox1 do for I:=0 to Items.Count-1 do if Items[I]=PortName then ItemIndex:=I;
  with ComboBox2 do for I:=0 to Items.Count-1 do if Items[I]=IntToStr(PortRate) then ItemIndex:=I
end;


procedure TForm3.ComboBoxANYKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Label3.Caption:=IntToHex(Key,4);
  if (Sender=ComboBox1) and CheckBox1.Checked then exit;
  if Key=VK_RETURN then Button2.Click
                   else if (Key<>VK_UP) and (KEY<>VK_DOWN) and (KEY<>VK_TAB) then Key:=0
end;


procedure TForm3.Label3Click(Sender: TObject);
begin
  with Label3.Font do if Color=clNone then Color:=clDefault
                                      else Color:=clNone
end;



end.

